package data.missions.corporateindirection;

import com.fs.starfarer.api.fleet.FleetGoal;
import com.fs.starfarer.api.fleet.FleetMemberType;
import com.fs.starfarer.api.mission.FleetSide;
import com.fs.starfarer.api.mission.MissionDefinitionAPI;
import com.fs.starfarer.api.mission.MissionDefinitionPlugin;
import data.scripts.SWPModPlugin;

public class MissionDefinition implements MissionDefinitionPlugin {

    @Override
    public void defineMission(MissionDefinitionAPI api) {
        api.initFleet(FleetSide.PLAYER, "EXI", FleetGoal.ATTACK, false);
        api.initFleet(FleetSide.ENEMY, "ISA", FleetGoal.ATTACK, true);

        api.setFleetTagline(FleetSide.PLAYER, "Test Unit A12");
        api.setFleetTagline(FleetSide.ENEMY, "Hypothetical Opfor");

        if (!SWPModPlugin.exigencyExists) {
            api.addBriefingItem("EXIGENCY INCORPORATED REQUIRED");
            api.addBriefingItem("Download Exigency Incorporated to play this mission!");
        }

        if (!SWPModPlugin.imperiumExists) {
            api.addBriefingItem("INTERSTELLAR IMPERIUM REQUIRED");
            api.addBriefingItem("Download Interstellar Imperium to play this mission!");
        }

        if (!SWPModPlugin.exigencyExists || !SWPModPlugin.imperiumExists) {
            return;
        } else {
            api.addBriefingItem("Test our tech against the opfor");
        }

        api.addToFleet(FleetSide.PLAYER, "exigency_carrier_Standard", FleetMemberType.SHIP, "EXI Alpha", true);
        api.addToFleet(FleetSide.PLAYER, "exigency_naxos_wing", FleetMemberType.FIGHTER_WING, false);
        api.addToFleet(FleetSide.PLAYER, "exigency_naxos_wing", FleetMemberType.FIGHTER_WING, false);
        api.addToFleet(FleetSide.PLAYER, "exigency_tarujan_wing", FleetMemberType.FIGHTER_WING, false);
        api.addToFleet(FleetSide.PLAYER, "exigency_tarujan_wing", FleetMemberType.FIGHTER_WING, false);

        api.addToFleet(FleetSide.ENEMY, "ii_olympus_a_sta", FleetMemberType.SHIP, "ISA Ragnarok", false);
        api.addToFleet(FleetSide.ENEMY, "ii_dictator_sta", FleetMemberType.SHIP, "ISA Rider", false);
        api.addToFleet(FleetSide.ENEMY, "ii_sebastos_sta", FleetMemberType.SHIP, "ISA Archer", false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_sta", FleetMemberType.SHIP, "ISA Berserker", false);
        api.addToFleet(FleetSide.ENEMY, "ii_praetorian_sta", FleetMemberType.SHIP, "ISA Maser", false);
        api.addToFleet(FleetSide.ENEMY, "ii_interrex_sta", FleetMemberType.SHIP, "ISA Lancer", false);
        api.addToFleet(FleetSide.ENEMY, "ii_maximus_str", FleetMemberType.SHIP, "ISA Saber", false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, "ISA Gravity", false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, "ISA Assassin", false);
        api.addToFleet(FleetSide.ENEMY, "ii_decurion_sta", FleetMemberType.SHIP, "ISA Diligence", false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_sta", FleetMemberType.SHIP, "ISA Laser", false);
        api.addToFleet(FleetSide.ENEMY, "ii_invictus_sta", FleetMemberType.SHIP, "ISA Spartan", false);

        float width = 14000f;
        float height = 20000f;
        api.initMap(-width / 2f, width / 2f, -height / 2f, height / 2f);

        for (int i = 0; i < 6; i++) {
            float x = (float) Math.random() * width - width / 2;
            float y = (float) Math.random() * height - height / 2;
            float radius = 100f + (float) Math.random() * 400f;
            api.addNebula(x, y, radius);
        }

        api.addObjective(width * 0.4f, -height * 0.15f, "sensor_array");
        api.addObjective(-width * 0.4f, -height * 0.15f, "sensor_array");

        api.addAsteroidField(0f, 0f, 120f, width * 0.5f, 10f, 40f, 150);
    }
}
